<p align="center">
  <img src="https://static.kickbox.io/kickbox_github.png" alt="Kickbox Email Verification Service">
  <br>
</p>

# Email Verification Library for PHP

[![Travis CI](https://travis-ci.org/kickboxio/kickbox-php.svg?branch=master)](https://travis-ci.org/kickboxio/kickbox-php)
[![Downloads](https://img.shields.io/packagist/dt/kickbox/kickbox.svg?maxAge=3600)](https://packagist.org/packages/kickbox/kickbox)
[![Packagist](https://img.shields.io/packagist/v/kickbox/kickbox.svg?maxAge=3600)](https://packagist.org/packages/kickbox/kickbox)
[![Slack Status](http://slack.kickbox.io/badge.svg)](http://slack.kickbox.com)

Kickbox determines if an email address is not only valid, but associated with a actual user. Uses include:

* Preventing users from creating accounts on your applications using fake, misspelled, or throw-away email addresses.
* Reducing bounces by removing old, invalid, and low quality email addresses from your mailing lists.
* Saving money and projecting your reputation by only sending to real email users.

## Getting Started

To begin, hop over to [kickbox.com](https://kickbox.com) and create a free account. Once you've signed up and logged in, click on **API Settings** and then click **Add API Key**. Take note of the generated API Key - you'll need it to setup the client as explained below.

## Installation

Make sure you have [composer](https://getcomposer.org) installed.

Add the following to your composer.json

```js
{
    "require": {
        "kickbox/kickbox": "*"
    }
}
```

Update your dependencies

```bash
$ php composer.phar update
```

> This package follows the `PSR-0` convention names for its classes, which means you can easily integrate these classes loading in your own autoloader.

#### Versions

Works with [ 5.4 / 5.5 ]

## Usage

```php
<?php

// This file is generated by Composer
require_once 'vendor/autoload.php';

$client   = new Kickbox\Client('Your_API_Key_Here');
$kickbox  = $client->kickbox();

try {
  $response = $kickbox->verify("test@example.com");
}
catch (Exception $e) {
  echo "Code: " . $e->getCode() . " Message: " . $e->getMessage();
}
```
#### Options

**timeout** `integer` (optional) - Maximum time, in milliseconds, for the API to complete a verification request. Default: 6000.

```php
// Example with options
$response = $kickbox->verify("test@example.com", array('timeout' => 6000));
```

### Response information

A successful API call responds with the following values:

* **result** `string` - The verification result: `deliverable`, `undeliverable`, `risky`, `unknown`
* **reason** `string` - The reason for the result. Possible reasons are:
    * `invalid_email` - Specified email is not a valid email address syntax
    * `invalid_domain` - Domain for email does not exist
    * `rejected_email` - Email address was rejected by the SMTP server, email address does not exist
    * `accepted_email` - Email address was accepted by the SMTP server
    * `low_quality ` - Email address has quality issues that may make it a risky or low-value address
    * `low_deliverability ` - Email address appears to be deliverable, but deliverability cannot be guaranteed
    * `no_connect` - Could not connect to SMTP server
    * `timeout` - SMTP session timed out
    * `invalid_smtp` - SMTP server returned an unexpected/invalid response
    * `unavailable_smtp` - SMTP server was unavailable to process our request
    * `unexpected_error` - An unexpected error has occurred
* **role** `true | false` - *true* if the email address is a role address (`postmaster@example.com`, `support@example.com`, etc)
* **free** `true | false` - *true* if the email address uses a free email service like gmail.com or yahoo.com.
* **disposable** `true | false` - *true* if the email address uses a *disposable* domain like trashmail.com or mailinator.com.
* **accept_all** `true | false` - *true* if the email was accepted, but the domain appears to accept all emails addressed to that domain.
* **did_you_mean** `null | string` - Returns a suggested email if a possible spelling error was detected. (`bill.lumbergh@gamil.com` -> `bill.lumbergh@gmail.com`)
* **sendex** `float` - A quality score of the provided email address ranging between 0 (no quality) and 1 (perfect quality). More information on the Sendex Score can be found [here](https://docs.kickbox.com/v2.0/docs/the-sendex).
* **email** `string` - Returns a normalized version of the provided email address. (`BoB@example.com` -> `bob@example.com`)
* **user** `string` - The user (a.k.a local part) of the provided email address. (`bob@example.com` -> `bob`)
* **domain** `string` - The domain of the provided email address. (`bob@example.com` -> `example.com`)
* **success** `true | false` - *true* if the API request was successful (i.e., no authentication or unexpected errors occurred)

An example response would look like:

```php
$response = $kickbox->verify('test@example.com');
var_dump($response);

//Below is an example of what the var_dump($response) looks like:

class Kickbox\HttpClient\Response#29 (3) {
  public $body =>
  array(13) {
    'result' =>
    string(11) "deliverable"
    'reason' =>
    string(14) "accepted_email"
    'role' =>
    bool(false)
    'free' =>
    bool(true)
    'disposable' =>
    bool(false)
    'accept_all' =>
    bool(false)
    'did_you_mean' =>
    NULL
    'sendex' =>
    int(1)
    'email' =>
    string(20) "test@example.com"
    'user' =>
    string(9) "test"
    'domain' =>
    string(10) "example.com"
    'success' =>
    bool(true)
    'message' =>
    NULL
  }
  public $code =>
  int(200)
  public $headers =>
  class Guzzle\Http\Message\Header\HeaderCollection#40 (1) {
    protected $headers =>
    array(11) {
      'server' =>
      class Guzzle\Http\Message\Header#41 (3) {
        ...
      }
      'date' =>
      class Guzzle\Http\Message\Header#42 (3) {
        ...
      }
      'content-type' =>
      class Guzzle\Http\Message\Header#43 (3) {
        ...
      }
      'content-length' =>
      class Guzzle\Http\Message\Header#44 (3) {
        ...
      }
      'connection' =>
      class Guzzle\Http\Message\Header#45 (3) {
        ...
      }
      'cache-control' =>
      class Guzzle\Http\Message\Header\CacheControl#46 (4) {
        ...
      }
      'pragma' =>
      class Guzzle\Http\Message\Header#47 (3) {
        ...
      }
      'expires' =>
      class Guzzle\Http\Message\Header#48 (3) {
        ...
      }
      'x-kickbox-balance' =>
      class Guzzle\Http\Message\Header#49 (3) {
        ...
      }
      'set-cookie' =>
      class Guzzle\Http\Message\Header#50 (3) {
        ...
      }
      'x-kickbox-response-time' =>
      class Guzzle\Http\Message\Header#51 (3) {
        ...
      }
    }
  }
}
```

### Response headers

Along with each response, the following HTTP headers are included:

* `X-Kickbox-Balance` - Your remaining verification credit balance (Daily + On Demand).
* `X-Kickbox-Response-Time` - The elapsed time (in milliseconds) it took Kickbox to process the request.

## License
MIT

## Bug Reports
Report [here](https://github.com/kickboxio/kickbox-php/issues).

## Need Help?
help@kickbox.com
